{$DeskAcc 150 -1 'Memory Bar' }
{$LongGlobals+}

program MemoryBar;
{
  Public domain
  
  by David A. Lyons (DAL Systems)
    P.O. Box 875
    Cupertino, CA 95014
    AppleLink--PE Dave Lyons
    CompuServe    72177,3233
    GEnie mail      D.LYONS2
  
  v1.0, 14-Feb-89
  v1.1, 13-Mar-89:  added a GetPort in DAOpen.  Duh.
  v1.2,  6-Jul-89:
     Spelled "purgeable" right to make Matt happy.
     Added code to force ROM Font to be used, even
       if the System font is large (to make Matt
       stop laughing).
     Updated address to California.
     Passes (0,0) for bottom right of Okay button
       rect, to let the system computer the size.
     Adjusted the edges of of the brackets a bit.
}

uses
  QDIntf, GSIntf, MiscTools, ConsoleIO;

const
  horSlop    = 6;   { space between bar and window edge }
  barHeight  = 5;   { height of memory use bar }
  barWidth   = 200; { width of memory use bar }
  vMainBar   = 4;   { vertical position of the bar's top }
  fontHeight = 8;   { bad:  assume Shaston 8 }
  vDivLine   = 28;  { vert position of dividing line }
  windHeight = 44;  { height of window }
  PenWidth   = 2;   { for framing rectangles }
  PenHeight  = 1;   { for framing rectangles }

  usedColor  = 14;
  purgeColor = 8;
  blockColor = 7;
  freeColor  = 15;   { white }

type
  showType = (showUsed, showPurge, showFree, showBlock,
              showTotal, notValid);
  Str32 = string[32];
  Str64 = string[64];
  
var
  myWindOpen:  boolean;
  myWind:      NewWindowParamBlk;
  MyWColors:   WindowColorTbl;
  myWindPtr:   WindowPtr;
  showWhat,
  oldShowWhat: showType;
  Message:     Str64;
  msgRect,
  bracketRect,
  smallRect,
  bigRect:   rect;
  usedPixels, purgePixels, blockPixels: integer;
  CompactBtn, AboutBtn: ControlHandle;
  bTotal, bFree, bRealFree, bUsed, bPurgeable, bBlock: longint;
  oFree, oRealFree, oBlock: longint;

procedure KeepValues;
begin
  oFree := bFree;
  oRealFree := bRealFree;
  oBlock := bBlock;
end;

function ValuesDiffer: boolean;
begin
  ValuesDiffer := (oFree<>bFree) or (oRealFree<>bRealFree) or
                  (oBlock<>bBlock);
end;

function rfmAvailable: boolean;
begin
  rfmAvailable := bitand(MMVersion,$7fff) >= $201;
end;

function myRealFreeMem: longint;
  function RealFreeMem: longint; tool 2,47;
begin
  if rfmAvailable then
    myRealFreeMem := RealFreeMem
  else
    myRealFreeMem := FreeMem;
end;

function CalcBarLen(tot, part: longint): integer;
begin
  CalcBarLen := (barWidth * part) div tot;
end;

procedure FrameBar(vert: integer);
var
  r: rect;
begin
  SetRect(r,0,0,barWidth,barHeight);
  OffsetRect(r,horSlop,vert);
  InsetRect(r,-penWidth,-penHeight);
  SetPenSize(penWidth,penHeight);
  SetDithColor(0);
  FrameRect(r);
  SetPenSize(1,1);
end;

procedure DrawBar(color, left, width: integer);
var
  r: rect;
begin
  SetDithColor(color);
  SetRect(r,0,0,width,barHeight);
  OffsetRect(r,left+horSlop,vMainBar);
  PaintRect(r);
end;

function Int2Str(L: longint): Str32;
var
  s: str32;
begin
  s := '';
  repeat
    s := concat(chr(48+(L mod 10)),s);
    L := L div 10;
  until L=0;
  Int2Str := s;
end;

function BuildMessage(what: Str32; Value: longint): Str64;
begin
  BuildMessage := concat(what, Int2Str(Value div 1024),
                    'K  (', Int2Str(value), ')');
end;

function GetValue(what: showType): longint;
var
  bPurge: longint;
begin
  case what of
    showUsed:   GetValue := TotalMem - myRealFreeMem;
    showFree:   GetValue := FreeMem;
    showPurge:  GetValue := myRealFreeMem - FreeMem;
    showBlock:  GetValue := MaxBlock;
    showTotal:  GetValue := TotalMem;
  end;
end;

procedure CheckInval;
var
  value: longint;
begin
  if (showWhat<>oldShowWhat) or ValuesDiffer then
  begin
  value := GetValue(showWhat);
    oldShowWhat := showWhat;
    KeepValues;
    case showWhat of
      showUsed:  Message := BuildMessage('In use: ', value);
      showPurge: Message := BuildMessage('Purgeable: ', value);
      showFree:  Message := BuildMessage('Free: ', value);
      showBlock: Message := BuildMessage('Max block: ', value);
      showTotal: Message := BuildMessage('Total: ', value);
    end;
    InvalRect(bigRect);
    EraseRect(msgRect);
    EraseRect(bracketRect);
  end;
end;

procedure DrawTextStuff;
begin
  MoveTo(msgRect.left, msgRect.bottom-1);
  DrawString(Message);
end;

procedure DrawCurrSelection(what: showType);
var
  left, width: integer;
  r: rect;
begin
  case what of
    showUsed:  begin left := -1; width := usedPixels+1 end;
    showPurge: begin left := usedPixels; width := purgePixels end;
    showFree:  begin
                 left := usedPixels+purgePixels;
                 width := barWidth - left + 1;
               end;
    showBlock: begin
                 left := barWidth - blockPixels;
                 width := blockPixels;
               end;
    showTotal: begin left := -1; width := barWidth+2 end;
  end;
  SetPenSize(PenWidth,PenHeight);
  SetDithColor(0);
  MoveTo(left+horSlop,vMainBar+barHeight+2);
  Line(0,2); Line(width-1,0);  Line(0,-2);
  SetPenSize(1,1);
end;

procedure DrawContent;
var
  r: rect;
begin
  { InvertRect(smallRect); }
  bFree     := FreeMem;
  bRealFree := myRealFreeMem;
  bBlock    := MaxBlock;
  bTotal    := TotalMem;
  bUsed     := bTotal - bRealFree;
  bPurgeable := bRealFree - bFree;
  CheckInval;
  if EmptyRgn(GetClipHandle) then exit;
  FrameBar(vMainBar);
  usedPixels  := CalcBarLen(bTotal,bUsed);
  purgePixels := CalcBarLen(bTotal,bPurgeable);
  blockPixels := CalcBarLen(bTotal,bBlock);
  DrawBar(usedColor,0,usedPixels);
  DrawBar(purgeColor,usedPixels,purgePixels);
  DrawBar(freeColor,usedPixels+purgePixels,
          barWidth-(usedPixels+purgePixels+blockPixels));
  DrawBar(blockColor,barWidth-blockPixels,blockPixels);
  DrawTextStuff;
  DrawCurrSelection(showWhat);
  SetSolidPenPat(0);
  { MoveTo(horSlop,vDivLine);  Line(barWidth,0); }
  MoveTo(0,vDivLine);  Line(barWidth+2*horSlop,0);
end;

procedure Show(what: showType);
begin
  if what = showPurge then
    if not rfmAvailable then
      what := showFree;
  if ShowWhat <> what then begin
    ShowWhat := what;
    InvalRect(bigRect);
    EraseRect(msgRect);
    EraseRect(bracketRect);
  end;
end;

{
  Do a CompactMem.  If Apple was down, allocate all possible
  memory first and then free it--this purges all purgeable
  memory blocks.
}
procedure DoCompact(modifiers: integer);
var
  size: longint;
  id: integer;
  h: handle;
  oldcur: CursorPtr;
begin
  oldcur := GetCursorAdr;
  WaitCursor;  { no effect if QD Auxiliary not started }
  if bitand(modifiers,appleKey)<>0 then begin
    HiliteControl(1,CompactBtn);
    id := GetNewID($5000);
    size := TotalMem;
    repeat
      repeat
        h := NewHandle(size,id,0,nil)
      until h=nil;
      size := size div 2;
    until size=0;
    DisposeAll(id);
    DeleteID(id);
    HiliteControl(0,CompactBtn);
  end;
  CompactMem;
  SetCursor(oldcur);
end;

procedure DoAbout;
var
  r: rect;
  x: integer;
  s: string[50];
  okay: string[10];
  aboutDlog: DialogPtr;
  oldPort:   WindowPtr;
begin
  oldPort := GetPort;
  SetRect(r,0,0,320,134);
  if bitand(GetMasterSCB,$80)<>0 then x := 160 else x := 0;
  OffsetRect(r,x,28);
  aboutDlog := NewModalDialog(r,true,0);
  case Random mod 8 of
    0: Okay := 'Yippee';
    1: Okay := 'Zow!';
    2: Okay := 'Awesome';
    3: Okay := 'Yeah';
    4: Okay := 'Cool';
    5: Okay := 'Oh Boy!';
    6: Okay := 'Nifty';
    7: Okay := 'Fer Sure';
  end;
  SetRect(r,210,110,0,0); { v1.2 }
  NewDItem(aboutDlog,1,r,10,@Okay,0,0,nil);
  SetBackColor(15); SetForeColor(0);
  SetPort(WindowPtr(aboutDlog));
  { title and version and date }
  MoveTo(50,15);  DrawString('Memory Bar 1.2--public domain');
  s := 'by David A. Lyons   6-Jul-89';
  MoveTo(58,30);  DrawString(s);
  MoveTo(58,30); TextBounds(@s[1],length(s),r);
  InsetRect(r,-4,-2);  SetPenSize(2,1);
  FrameRect(r);        SetPenSize(1,1);
  { decorative bar }
  SetDithColor(1);
  MoveTo(20,43); SetPenSize(1,3); Line(280,0); SetPenSize(1,1);
  SetSolidPenPat(3);
  { address }
  MoveTo(10,60);  DrawString('Watch for Shareware from:');
  MoveTo(14,75);  DrawString('DAL Systems');
  MoveTo(14,84);  DrawString('P.O. Box 875');
  MoveTo(14,93);  DrawString('Cupertino, CA');
  MoveTo(55,102); DrawString('95015-0875');
  MoveTo(130,75); DrawString('CompuServe 72177,3233');
  MoveTo(130,84); DrawString('GEnie mail D.LYONS2');
  MoveTo(130,93); DrawString('AppleLink--PE Dave Lyons');
  MoveTo(10,114); DrawString('Try 1-5, Tab, and clicking');
  MoveTo(10,124); DrawString('on parts of the bar.');
  { wait for OK with arrow cursor }
  repeat until ModalDialog(nil)=1;
  SetPort(oldport);
  CloseDialog(aboutDlog);
end;

procedure DoMouseDown(theEvent: EventRecord);
var
  h, v, x, y: integer;
  TheCtl: ControlHandle;
begin
   x := theEvent.where.h;  y := theEvent.where.v;
   if FindControl(TheCtl,x,y,myWindPtr)<>0 then
     if TrackControl(x,y,nil,TheCtl)<>0 then begin
       if TheCtl=CompactBtn then begin
         DoCompact(theEvent.modifiers);
         exit
       end else if TheCtl=AboutBtn then begin
         DoAbout;
         exit
       end;
     end;
   GlobalToLocal(theEvent.where);
   h := theEvent.where.h;
   v := theEvent.where.v;
   if (v<bracketRect.bottom) and (v>=vMainBar) then begin
     h := h - horSlop;
     if h<0 then exit;
     if h<usedPixels then
       begin show(showUsed); exit end;
     if h<usedPixels+purgePixels then
       begin show(showPurge); exit end;
     if h<barWidth-blockPixels then
       begin show(showFree); exit end;
     if (h>=barWidth-blockPixels) and (h<barWidth) then
       begin show(showBlock); exit end;
   end;
   if v<vDivLine then begin show(showTotal); exit end;
end;

procedure DoKeyDown(key: char);
begin
  case key of
    '1', 't', 'T': show(showTotal);
    '2', 'u', 'U': show(showUsed);
    '3', 'p', 'P': show(showPurge);
    '4', 'f', 'F': show(showFree);
    '5', 'm', 'M': show(showBlock);
    '/', '?': begin
      HiliteControl(1,AboutBtn);
      HiliteControl(0,AboutBtn);
      DoAbout;
    end;
  end;
  if key=chr(9) then
    if succ(showWhat)=notValid then
      show(showUsed)
    else
      show(succ(showWhat));
end;

function DAOpen: WindowPtr;
var
  oldPort: WindowPtr;
  r: rect;
  RomFontInfo: record   { added for v1.2 }
    Family, Style, Size: integer;
    fHand:  handle;
    NamePtr: ptr;
    extent: integer;
    x1, x2, x3, x4, x5: integer; { room for expansion? }
  end;
begin
  if myWindOpen then exit;
  oldPort := GetPort;  { added for v1.1 }
  fillchar(myWind,sizeof(NewWindowParamBlk),0);
  with myWind do begin
    param_length := sizeof(NewWindowParamBlk);
    wFrame       := $C0E8;
    wTitle       := @' Memory Bar ';
    SetRect(wPosition,0,0,barWidth+2*horSlop,windHeight);
    OffsetRect(wPosition,50,40);
    wPlane       := -1;
    wColor       := @MyWColors;
  end;
  myWindPtr := NewWindow(myWind);
  DAOpen    := myWindPtr;
  SetSysWindow(myWindPtr);
  myWindOpen := true;
  SetRect(r,0,0,80,11);  OffsetRect(r,18,vDivLine+3);
  CompactBtn := NewControl(myWindPtr,r,'Compact',0,0,0,0,nil,0,nil);
  OffsetRect(r,95,0);
  AboutBtn   := NewControl(myWindPtr,r,'About...',0,0,0,0,nil,0,nil);
  {--- added for v1.2 ---}
  SetPort(myWindPtr);
  GetRomFont(@RomFontInfo);
  SetFont(RomFontInfo.fHand);
  {--- end of 1.2 additions ---}
  SetPort(oldPort);
  showWhat := showFree;
  oldShowWhat := notValid;
  SetRect(msgRect,0,0,1000,12);
  OffsetRect(msgRect,horSlop,vMainBar+barHeight+5);
  SetRect(bracketRect,0,0,barWidth+3,4);
  OffsetRect(bracketRect,horSlop-1,vMainBar+barHeight+1);
  SetRect(smallRect,0,0,6,3);
  SetRect(bigRect,0,0,1000,vDivLine);
end; { of DAOpen }

procedure DAClose;
begin
  if myWindOpen then CloseWindow(myWindPtr);
  myWindOpen := false;
end;

procedure DAAction(Code: Integer; Param: EventRecordPtr);
var
  currPort: GrafPtr;
  what: Integer;
  modifiers: Integer;
  key: char;
begin
  case Code of
    DAEvent: begin
      currPort := GetPort;
      SetPort(myWindPtr);
      what := EventRecordPtr(param)^.what;
      case what of
        updateEvt:
          begin
            BeginUpdate(myWindPtr);
            DrawContent;
            DrawControls(myWindPtr);
            EndUpdate(myWindPtr);
          end;
        keyDown:   DoKeyDown(char(loword(param^.message)));
        mouseDown: DoMouseDown(param^);
      end; { case event }
      SetPort(currPort);
    end;
    DARun:
      begin
        currPort := GetPort;
        SetPort(myWindPtr);
        DrawContent;
        SetPort(currPort);
      end;
    DACursor: ;
  end;
end; { of DAAction }

procedure DAInit(Code: Integer);
begin
  with MyWColors do begin
    FrameColor := $0000;
    TitleColor := $0f00;
    TBarColor  := $020f;
    GrowColor  := $f0f0;
    InfoColor  := $00f0;
  end;
  if Code = 0 then begin
    { A DeskShutDown Call: chk that my window is closed }
    if myWindOpen then DAClose;
  end else begin
    { A DeskStartUp Call: init myWindOpen flag }
    myWindOpen := false;
  end;
end;

begin
  { no main program }
end.
